# 🤖 Mas Angga - WhatsApp AI Bot

Bot WhatsApp AI bernama **"Mas Angga"** dengan 4 fitur utama: curhat empatis, bantuan belajar, download TikTok tanpa watermark, dan verifikasi e-wallet yang aman.

## ✨ Fitur Utama

- 💝 **Curhat/Emotional Support**: AI empatis yang mendengarkan dan memberikan dukungan emosional menggunakan nama personal
- 📚 **Bantuan Belajar**: Tutor AI untuk membantu PR, tugas sekolah, dan pembelajaran dengan penjelasan detail
- 🎬 **Download TikTok**: Download video TikTok tanpa watermark dengan auto-detect URL
- 💳 **Verifikasi E-Wallet**: Cek info provider dan kemungkinan e-wallet dengan cara yang aman dan legal
- 🎭 **Personal Touch**: Menggunakan nama user (bukan "kamu") untuk percakapan yang lebih personal  
- 🧠 **Auto Mode Detection**: Otomatis mendeteksi mode chat (curhat/belajar) berdasarkan konteks
- 💭 **Conversation Memory**: Mengingat nama dan konteks percakapan untuk dialog yang natural
- 🤖 **Groq AI Integration**: Menggunakan Groq API (gratis) untuk respons yang cerdas dan cepat

## 🚀 Quick Start

### ⚡ Setup Cepat (Recommended)
```bash
# Double-click atau jalankan:
quick-setup.bat
```

### 📋 Setup Manual

1. **Install Dependencies**
   ```bash
   npm install
   ```

2. **Setup API Key (Opsional)**
   - Daftar gratis di: https://console.groq.com/keys
   - Copy API key ke file `.env`
   - Atau gunakan demo mode tanpa API key

3. **Jalankan Bot**
   ```bash
   npm start
   ```

4. **Scan QR Code**
   - QR code muncul di terminal
   - Scan dengan WhatsApp (Menu → Linked Devices)
   - Bot siap digunakan!## 💬 Cara Menggunakan Bot

### 🎯 **4 Fitur Utama Mas Angga:**

#### 1. **💝 Curhat (Emotional Support)**
```
User: "aku sedih nih mas"
Bot: "Eh [Nama], kenapa sedih? Cerita dong sama Mas Angga..."
```

#### 2. **📚 Bantuan Belajar**
```
User: "jelaskan fotosintesis"
Bot: "[Nama], fotosintesis itu proses tumbuhan bikin makanan..."
```

#### 3. **🎬 Download TikTok (No Watermark)**
```
User: "https://vt.tiktok.com/ZSjQxPqR8/"
Bot: "📥 Sedang download TikTok untuk [Nama]..."
```

#### 4. **💳 Cek E-Wallet (Safe)**
```
User: "cek ewallet 081234567890"
Bot: "📱 Provider: Telkomsel | 💳 E-wallet yang bisa: Dana, OVO..."
```

### 🚀 **Chat Natural**
- Tidak perlu command khusus
- Bot otomatis detect mode (curhat/belajar)
- Menggunakan nama personal (bukan "kamu")
- Support multiple users bersamaan

## 📚 Dokumentasi Lengkap

- 📖 **[QUICK_GUIDE.md](QUICK_GUIDE.md)** - Panduan 5 menit
- 💬 **[CONTOH_CHAT.md](CONTOH_CHAT.md)** - Contoh percakapan lengkap
- 📋 **[CARA_PAKAI_BOT.md](CARA_PAKAI_BOT.md)** - Manual detail

## 🛠 Tech Stack

- **Node.js** - Runtime JavaScript  
- **Baileys** - WhatsApp Web API Library
- **Groq AI** - Fast & free AI API untuk responses
- **axios** - HTTP client untuk API calls
- **dotenv** - Environment variable management
- **qrcode-terminal** - QR code display untuk autentikasi

## 📁 Struktur Project

```
botwa/
├── index.js                 # Main bot application
├── ai-service.js           # Groq AI service dengan personality Mas Angga
├── tiktok-service.js       # TikTok download service (no watermark)
├── ewallet-service.js      # E-wallet verification service  
├── package.json            # Dependencies dan scripts
├── .env                    # Environment variables
├── quick-setup.bat         # Auto setup script
├── README.md               # Documentation ini
├── QUICK_GUIDE.md          # Panduan cepat 5 menit
├── CONTOH_CHAT.md         # Contoh percakapan lengkap
├── CARA_PAKAI_BOT.md      # Manual detail penggunaan
└── auth/                   # WhatsApp auth data (auto-generated)
```

## 🤖 Keunggulan Mas Angga

### 🎭 **Personality Unik**
- **Nama Personal**: Menggunakan nama user, bukan "kamu"
- **Empati Tinggi**: Respon yang natural dan caring
- **Auto-Detect**: Pintar mendeteksi mood dan kebutuhan
- **Indonesian Casual**: Bahasa yang santai tapi sopan

### 🚀 **Fitur Canggih**
- **Multi-Service**: 4 layanan dalam 1 bot
- **No Command**: Chat natural tanpa command khusus
- **Multi-User**: Support banyak user bersamaan
- **Auto-Reconnect**: Otomatis reconnect jika disconnect

### 💡 **Smart Detection**
- **Curhat Mode**: Deteksi kata emosional (sedih, galau, stress)
- **Study Mode**: Deteksi kata akademik (jelaskan, bantu, belajar)
- **TikTok URLs**: Auto-detect dan prioritas processing
- **E-wallet Numbers**: Pattern matching untuk nomor HP

## 🔧 Troubleshooting

### **QR Code tidak muncul**
```bash
Ctrl+C → npm start
```

### **Bot tidak respon**
1. Cek API key di `.env`
2. Restart: `npm start`
3. Cek koneksi internet

### **TikTok download gagal**
- URL mungkin expired/invalid
- Video mungkin private
- Coba URL yang baru

### **Dependencies error**
```bash
npm install --force
npm audit fix
```

## ⚠️ Important Notes

- **Groq API**: Gratis dengan rate limit, daftar di console.groq.com
- **Privacy**: Nama user disimpan di memory (hilang saat restart)  
- **TikTok**: Menggunakan API publik, success rate ~90%
- **E-wallet**: Hanya info umum, tidak ada data pribadi
- **Multi-User**: Each user has separate context & name

## 🔒 Security & Legal

### **Privacy Protection**
- API key di environment variables
- Tidak ada data tersimpan ke database
- Riwayat chat hanya di memory
- E-wallet check hanya info umum carrier

### **Legal Compliance**  
- TikTok download untuk personal use only
- E-wallet verification tanpa akses data pribadi
- Tidak ada hacking atau illegal activities
- Educational purpose untuk digital security awareness

## 🎯 Fitur Mendatang

- [ ] Voice message support
- [ ] Image recognition & description  
- [ ] YouTube video download
- [ ] Instagram post download
- [ ] Schedule reminder system
- [ ] Multi-language support
- [ ] Custom personality training

## 🤝 Contributing

Mau bantu develop? Welcome banget!

1. Fork repository
2. Create feature branch
3. Commit changes  
4. Push to branch
5. Create Pull Request

## 📞 Support

Jika ada masalah atau pertanyaan:
- 📖 Baca dokumentasi lengkap
- 🔄 Coba restart bot
- 💡 Check troubleshooting section
- 🎯 Lihat contoh chat di CONTOH_CHAT.md

## 📄 License

MIT License - Bebas dimodifikasi untuk keperluan pribadi!

---

## 🏆 Status: Production Ready

**Bot Mas Angga siap digunakan!** 🎉

✅ AI Conversation dengan empati  
✅ Personal naming system  
✅ TikTok download tanpa watermark  
✅ E-wallet verification aman  
✅ Auto mode detection  
✅ Multi-user support  
✅ Complete documentation

**Happy chatting dengan Mas Angga!** 🤖💝
