#!/bin/bash

echo "🚀 Installing WhatsApp Bot Mas Angga..."

# Check Node.js
if ! command -v node &> /dev/null; then
    echo "❌ Node.js not found! Please install Node.js first."
    exit 1
fi

echo "✅ Node.js found: $(node --version)"

# Install dependencies
echo "📦 Installing dependencies..."
npm install --production

# Setup environment
if [ ! -f .env ]; then
    echo "🔧 Creating .env file..."
    cp .env.example .env
    echo "⚠️  IMPORTANT: Edit .env file with your API keys!"
    echo "   nano .env"
fi

# Setup PM2 if available
if command -v pm2 &> /dev/null; then
    echo "🔄 Setting up PM2..."
    pm2 start ecosystem.config.js
    pm2 save
    echo "✅ Bot started with PM2!"
    echo "🔍 Check status: pm2 list"
    echo "📊 View logs: pm2 logs mas-angga-bot"
else
    echo "⚠️  PM2 not found. Install with: npm install -g pm2"
    echo "🚀 Starting bot manually..."
    echo "   npm start"
fi

echo ""
echo "🎉 Installation complete!"
echo "📱 Access QR Code: http://yourdomain.com/qr"
echo "💡 Setup guide: cat SETUP_HOSTING.md"
